const express    = require('express');
const cors       = require('cors');
const jwt        = require('jsonwebtoken');
const bodyParser = require('body-parser');

const images = require('../dashboard/images');

const PORT  = 3333;
const STAGE = 'avior';

// setup server and configure CORS
const app = express();
app.use(cors({exposedHeaders: 'X-Total-Count'}));

// parse application/json
app.use(bodyParser.json())

// rebuild request to match API GATEWAY response
const ApiEvent = (req) => {
    const authToken    = req.headers.authorization;
    const decodedToken = jwt.decode(authToken, {verify: false});
    return {
        resource                         : req.route.path
            .replace(`/${STAGE}`, '')
            .replace(/(.*):(.*)/, "$1{$2}")
        , httpMethod                     : req.method
        , path                           : req.url
        , body                           : JSON.stringify(req.body)
        , multiValueQueryStringParameters: req.query
        , requestContext                 : {
            authorizer: {
                claims: {
                    sub      : decodedToken.sub
                    , userSrc: decodedToken.userSrc
                    , exp    : decodedToken.exp
                }
            }
        }
    }
}

const handleRequest = async (req, res) => {

    // reformatting the express req to an AWS-API event so I can test locally
    // const AWS_API_GW_EVENT = ApiEvent(req)
    const AWS_API_GW_EVENT = {
        resource  : '/dashboard/images',
        httpMethod: 'POST'
    }
    let response;
    switch (req.route.path.substr(req.route.path.lastIndexOf('/'))) {
        case '/images':
            response = await images.main(AWS_API_GW_EVENT);
            break;
    }
    // res.json(JSON.parse(response.body));
    console.log(response)
}
app.get('/avior/dashboard/images', handleRequest);

app.listen(PORT, () => console.log(`API server app listening on port ${PORT}!`))
