async function extractAuthorizationClaim(event) {

    // the authorizer should be present or the API-Gateway does not provide the authorizer
    if (!event.requestContext.authorizer) {
        throw Error('No authorization set on endpoint');
    }

    try {
        if (!event.requestContext.authorizer.claims.sub) throw Error('no sub in Claim');
        if (!event.requestContext.authorizer.claims.userSrc) throw Error('no userSrc in Claim');
        if (!event.requestContext.authorizer.claims.exp) throw Error('no TenantId in exp');
        return {
            userSub : event.requestContext.authorizer.claims.sub,
            userSrc : event.requestContext.authorizer.claims.userSrc,
            exp     : event.requestContext.authorizer.claims.exp
        };
    } catch (err) {
        console.error(err.stack.toString());
    }
}

module.exports = {
    extractAuthorizationClaim
}
