module.exports = {
    success,
    failure
}

function success(body) {
    return buildResponse(200, body);
}

function failure(err) {
    return buildResponse(500, {
        error: err.toString().replace(/error: /gi, "")
    });
}

function buildResponse(statusCode, response) {
    let body                = ''
        , xTotalCountHeader = 1;

    switch (typeof response) {
        case 'object':
            if (response.data) {
                body              = JSON.stringify(response.data);
                xTotalCountHeader = response.total;
            } else {
                body = JSON.stringify(response);
            }
            break;
        default:
            body = response.toString();
    }

    return {
        statusCode: statusCode,
        headers   : {
            "Access-Control-Allow-Origin"     : "*",
            "Access-Control-Allow-Credentials": true,
            "Access-Control-Expose-Headers": "X-Total-Count",
            "X-Total-Count": xTotalCountHeader
        },
        body      : body
    };
}
